

#/////////////////////////////////////////////////////////////#
#________________ IMPORTATION DES DONNEES ____________________#
#/////////////////////////////////////////////////////////////#

### Charger les deux bases ###
require(CASdatasets)
data("freMTPLfreq")
data("freMTPLsev")
head(freMTPLfreq)
head(freMTPLsev)

base.contrat <- freMTPLfreq
base.sinistre <- freMTPLsev

#/////////////////////////////////////////////////////////////#
#____________ Preparation des bases de donnees _______________#
#/////////////////////////////////////////////////////////////#

############### Fusion des bases contrat et sinistre ###############
## Fusionner les deux bases: on cumule les montants associes a un contrat multisinistre.
base.sinistresAgreges <- aggregate(base.sinistre$ClaimAmount, by = list(base.sinistre$PolicyID), sum)
colnames(base.sinistresAgreges) <- c("PolicyID","ClaimAmount") ; head(base.sinistresAgreges) ; dim(base.sinistresAgreges)
base.complete <- merge(x = base.contrat, y = base.sinistresAgreges, by = "PolicyID", all.x = TRUE)
dim(base.complete)
base.complete$ClaimAmount <- replace(base.complete$ClaimAmount, which(is.na(base.complete$ClaimAmount)), 0)
head(base.complete)			# View(head(base.complete))
colnames(base.complete) <- c("Id","NbSinistre","Exposition","Puissance","AgeVoiture","AgeConducteur","Marque","Gaz","Région","Densité","Sinistralite.agregee")
head(base.complete)

############### Modifier les types des variables ###############
str(base.complete)																# permet de voir le type des variables
base.complete$NbSinistre <- as.numeric(base.complete$NbSinistre)				# rendre les variables de type entier en numerique
base.complete$AgeVoiture <- as.numeric(base.complete$AgeVoiture)
base.complete$AgeConducteur <- as.numeric(base.complete$AgeConducteur)
base.complete$Densité <- as.numeric(base.complete$Densité)

## On enleve certaines donnees aberrantes: par exemple une exposition plus grande que 1 (la base est censee etre collectee sur une annee civile)
base.complete <- base.complete[-which(base.complete$Exposition > 1), ]
nrow(base.complete)


#////////////////////////////////////////////////////////////#
#___________ Traitement de la sinistralite CAT ______________#
#////////////////////////////////////////////////////////////#
## Premierement, on ecrete la base de donnees des sinistres CAT car ces donnees ne doivent pas servir dans l'etude descriptive qui va servir a faire des choix pour la modelisation GLM.
## Determination du seuil des valeurs extremes: voir par exemple http://www.bioss.ac.uk/people/adam/teaching/OR_EVT/2007/node23.html
summary(base.complete$Sinistralite.agregee)
boxplot(base.complete$Sinistralite.agregee)

## Comme les graphiques precedents ne permettent pas de conclure 'proprement', on choisit un seuil arbitraire defini par un quantile empirique:
(seuil <- quantile(base.complete$Sinistralite.agregee[base.complete$Sinistralite.agregee > 0], probs = 0.95))
baseauto.attri <- base.complete[base.complete$Sinistralite.agregee < seuil, ]
nrow(baseauto.attri)
summary(baseauto.attri)
head(baseauto.attri)
## Histogramme de la severite attritionnelle : le pic en 0 ecrase le reste de la densite sur le premier graphique.
quartz(width = 11, height = 6.5) ; plot(density(baseauto.attri$Sinistralite.agregee), main = "Densite des montants attritionnels des contrats, incluant les non sinistres")
## En fait la densite empirique ressemble davantage a une loi melange...peut-etre que des profils de la population se cachent derriere chacun de ces modes, ou des franchises, ou autre :
quartz(width = 10.5, height = 6.5) ; plot(density(baseauto.attri$Sinistralite.agregee[baseauto.attri$Sinistralite.agregee != 0]), main = "Densite des montants attritionnels des contrats sinistres")
quartz(width = 10.5, height = 6.5) ; hist(baseauto.attri$Sinistralite.agregee[baseauto.attri$Sinistralite.agregee != 0], breaks = 100, main = "Densite des montants attritionnels des contrats sinistres")

## Severite CAT :
baseauto.sinistree.cat <- base.complete[base.complete$Sinistralite.agregee >= seuil, ]
nrow(baseauto.sinistree.cat)
summary(baseauto.sinistree.cat)
head(baseauto.sinistree.cat)
nrow(baseauto.sinistree.cat) / nrow(base.complete[base.complete$Sinistralite.agregee != 0, ])		# environ 5% des charges des contrats sinistres, conformement au quantile choisi precedemment
sum(baseauto.sinistree.cat$Sinistralite.agregee) / sum(base.complete$Sinistralite.agregee)			# 5% des sinistres represente 50% de la sinistralite
(prime.cat <- sum(baseauto.sinistree.cat$Sinistralite.agregee) / nrow(base.complete))				# prime pr la partie CAT, a repartir sur l'ensemble de la population, sans segmentation.

####### On stocke les contrats sinistres de la base attritionnelle dans l'objet 'baseauto.sinistree.attri' pour travailler plus loin dessus (dans le modele de cout moyen):
baseauto.sinistree.attri <- baseauto.attri[baseauto.attri$Sinistralite.agregee > 0, ]
nrow(baseauto.sinistree.attri)
summary(baseauto.sinistree.attri)


#////////////////////////////////////////////////////////////////////#
#___________ Stats descriptives univariees / bivariees ______________#
#////////////////////////////////////////////////////////////////////#

######### Severite globale moyenne des contrats sinistres et non-sinistres (y compris CAT) #########
mean(base.complete$Sinistralite.agregee)		# prime collective a demander a tout le monde si aucune segmentation
######### Severite ATTRITIONNELLE moyenne des contrats sinistres et non-sinistres par individu #########
mean(baseauto.attri$Sinistralite.agregee)		# prime moyenne a ajouter a la prime CAT si aucune segmentation
prime.cat
######### Severite attritionnelle moyenne des contrats sinistres uniquement #########
mean(baseauto.sinistree.attri$Sinistralite.agregee)
######### Severite globale moyenne des contrats sinistres uniquement (y compris CAT) #########
mean(base.complete$Sinistralite.agregee[base.complete$Sinistralite.agregee > 0])
## => On constate que le cout moyen double quasiment lorsque nous incluons les sinistres CAT (ceci est coherent avec le fait que les CAT represente environ 50% de la sinistralite globale).


################# Variables qualitatives ##################
library(ggplot2)

####### Puissance: 
round( prop.table(table(baseauto.attri$Puissance)) * 100, 2)				# exposition en fonction du type de la puissance du vehicule dans la base complete (sinistree et non-sinistree)
quartz(width = 10.6, height = 6.5) ; ggplot(baseauto.attri, aes(x = Puissance, fill = Puissance)) + geom_bar() + labs(title="Exposition par puissance moteur") + ylab("Effectif") + scale_fill_hue(c = 80)
round( prop.table(table(baseauto.sinistree.attri$Puissance)) * 100, 2)		# exposition en fonction du type de la puissance du vehicule dans la base sinistree attritionnelle
## Lien cout moyen (attritionnel) d'un contrat - puissance du vehicule: on prend uniquement la base sinistree car les modeles performants seront des modeles inflates ou tronques en zero...donc les facteurs
## de risque n'interviendront que dans la composante pour la loi du montant lorsqu'il est different de zero (on aurait aussi pu integrer des covariables pour la composante en 0 certes).
cSinistre_Puissance_w <- tapply(baseauto.sinistree.attri$Sinistralite.agregee, baseauto.sinistree.attri$Puissance, mean)		# severite moyenne par categorie de puissance 
(Cpuissance <- data.frame(puissance = names(cSinistre_Puissance_w), cout = cSinistre_Puissance_w))
quartz(width = 10.6, height = 6.5)
ggplot(Cpuissance, aes(puissance, cout, fill = puissance)) +
	geom_bar(stat = "identity")
## => Conclusion POUR EXPLIQUER LA LOI DE COUT MOYEN: on doit pouvoir regrouper 'e', 'h' et 'i'; ainsi que 'd','g', et 'l'; ainsi que 'n' et 'o'.

## On ferait pareil avec les autres variables...

################## Variables quantitatives ##################

####### AgeConducteur :
summary(baseauto.attri$AgeConducteur)
quantile(baseauto.attri$AgeConducteur, seq(0.1, 1, by = 0.1))		# 90% des conducteurs ont 66 ans ou moins, le plus jeune a 18 ans et le plus vieux a 99 ans!
quantile(baseauto.sinistree.attri$AgeConducteur, seq(0.1, 1, by = 0.1))
quartz(width=10.5, height=6.5) ; ggplot(baseauto.sinistree.attri, aes(AgeConducteur)) + geom_histogram(aes(y=..density.., fill=..density..)) + labs(title="Densite age") + ylab("Dens.") + xlab("Age conduc.")
#### Lien entre le cout moyen et l'age du conducteur:
liste.age <- sort(unique(baseauto.sinistree.attri$AgeConducteur))
CoutMoysinistre_AgeConducteur.f <- rep(0, length(liste.age))
for (i in 1:length(liste.age)) {
	b <- NULL ; b <- baseauto.sinistree.attri[baseauto.sinistree.attri$AgeConducteur == liste.age[i], ]
	CoutMoysinistre_AgeConducteur.f[i] <- mean(b$Sinistralite.agregee)
}
(cout_moy_AgeConduc <- data.frame(ageConducteur = liste.age, CoutMoysinistre_AgeConducteur.f))
quartz(width = 10.6, height = 6.5) ; plot(x = cout_moy_AgeConduc$ageConducteur, y = cout_moy_AgeConduc$CoutMoysinistre_AgeConducteur.f)

## Et on ferait pareil avec les autres variables


#///////////////////////////////////////////////////////////////////////////////////////////////////////////#
#___________ Gestion des modalites des facteurs de risque suite aux statistiques descriptives ______________#
#///////////////////////////////////////////////////////////////////////////////////////////////////////////#

############ Variables qualitatives: regroupement de modalites ##############

###### Puissance :
## => Conclusion POUR EXPLIQUER LA LOI DU COUT: on doit pouvoir regrouper 'e', 'h' et 'i'; ainsi que 'd','g', et 'l'; ainsi que 'n' et 'o'.
table(baseauto.attri$Puissance)
levels(baseauto.attri$Puissance)[match("d", levels(baseauto.attri$Puissance))] <- "d-g-l"
levels(baseauto.attri$Puissance)[match("e", levels(baseauto.attri$Puissance))] <- "e-h-i"
levels(baseauto.attri$Puissance)[match("g", levels(baseauto.attri$Puissance))] <- "d-g-l"
levels(baseauto.attri$Puissance)[match("h", levels(baseauto.attri$Puissance))] <- "e-h-i"
levels(baseauto.attri$Puissance)[match("i", levels(baseauto.attri$Puissance))] <- "e-h-i"
levels(baseauto.attri$Puissance)[match("l", levels(baseauto.attri$Puissance))] <- "d-g-l"
levels(baseauto.attri$Puissance)[match("n", levels(baseauto.attri$Puissance))] <- "n-o"
levels(baseauto.attri$Puissance)[match("o", levels(baseauto.attri$Puissance))] <- "n-o"
table(baseauto.attri$Puissance)

###### Marque :
## => Conclusion POUR EXPLIQUER LA LOI DE COUT: on doit pouvoir regrouper 'Opel, GM, Ford' et 'Renault, ...'; ainsi que 'Mercedes, ...', 'Other' et 'Volskwagen, ...'
table(baseauto.attri$Marque)
levels(baseauto.attri$Marque) <- c("Fiat","JK","MCB-Oth-VASS","OGMF-RNC","MCB-Oth-VASS","OGMF-RNC","MCB-Oth-VASS")
table(baseauto.attri$Marque)

###### Region :
## => Conclusion PR EXPLIQUER LA LOI COUT MOYEN : regrouper "BRETAGNE" et "POITOU-CHAR."; "CENTRE", "PAYS DE LA LOIRE" et "LIMOUSIN"; "IDF", "HAUTE-NORM." et "AQUITAINE"; "BASSE-NORM." et "NORD-PAS-DE-CALAIS"
table(baseauto.attri$Région)
## Autre moyen d'affecter de nouvelles modalites (plus long mais plus propre et plus facile a lire):
levels(baseauto.attri$Région) <- c(levels(baseauto.attri$Région), "BRET-PC", "CENTRE-PDL-LIM", "IDF-HN-AQUIT", "BN-NPDC")
baseauto.attri$Région[baseauto.attri$Région %in% c("BRET","PC")] <- "BRET-PC"
baseauto.attri$Région[baseauto.attri$Région %in% c("CENTRE","PDL","LIM")] <- "CENTRE-PDL-LIM"
baseauto.attri$Région[baseauto.attri$Région %in% c("IDF","HN","AQUIT")] <- "IDF-HN-AQUIT"
baseauto.attri$Région[baseauto.attri$Région %in% c("BN","NPDC")] <- "BN-NPDC"
baseauto.attri$Région <- factor(baseauto.attri$Région)
table(baseauto.attri$Région)

############ Variables quantitatives: segmentation ############### 

###### Age du conducteur :
## => Conclusion: il semble que pour expliquer le cout moyen de la sinistralite l'age du conducteur soit a segmenter! Par exemple [18,25[, [25,70[, > 70
baseauto.attri$AgeConducteur <- cut(baseauto.attri$AgeConducteur, c(17,25,70,Inf), include.lowest = TRUE)
table(baseauto.attri$AgeConducteur)
sum(table(baseauto.attri$AgeConducteur)) == nrow(baseauto.attri)		# verification

###### Age de la voiture :
## => Conclusion: il semble que le cout moyen soit decroissant en fonction de l'age du vehicule (quand on cree des classes, sinon ce n'est pas evident).
baseauto.attri$AgeVoiture <- cut(baseauto.attri$AgeVoiture, c(0,5,10,Inf), include.lowest = TRUE)
table(baseauto.attri$AgeVoiture)

###### Densite de population :
## Conclusion: le cout moyen est croissant en fonction de la densite de population lorsque cette variable est categorisee.
baseauto.attri$Densité <- cut(baseauto.attri$Densité, c(0,100,1000,Inf), include.lowest = TRUE)
table(baseauto.attri$Densité)


#////////////////////////////////////////////////////////////////#
#___________ Definition de l'individu de reference ______________#
#////////////////////////////////////////////////////////////////#

########### On definit les modalites de reference en univarie: on regarde les plus representes variable par variable.
idCateg <- which(sapply(1:NCOL(baseauto.attri), function(i) class(baseauto.attri[ ,i])) == "factor")
nameCateg <- colnames(baseauto.attri)[idCateg]
refCateg <- sapply(idCateg, function(i) names(which.max(table(baseauto.attri[ ,i]))))
data.frame(indice.colonne = idCateg, facteur.risque = nameCateg, nom.modalite.reference = refCateg)
## Mise a jour de la modalite de reference:
for (j in 1:length(idCateg)) { baseauto.attri[ ,idCateg[j]] <- relevel(baseauto.attri[ ,idCateg[j]], ref = refCateg[j]) }


#/////////////////////////////////////////////////////////////////////////////////////#
#___________ Creation des echantillons d'apprentissage et de validation ______________#
#/////////////////////////////////////////////////////////////////////////////////////#
set.seed(100)

#_______________Tirage aleatoire sans stratification 2/3 des assures d'un cote, et 1/3 de l'autre______________#
(taille_echan <- floor( (2/3) * nrow(baseauto.attri) ))
ech.appren_indexes <- sample(seq_len(nrow(baseauto.attri)), size = taille_echan)
baseauto_appren <- baseauto.attri[ech.appren_indexes, ]
baseauto_vali <- baseauto.attri[-ech.appren_indexes, ]
baseauto_appren.origine <- baseauto_appren
baseauto_vali.origine <- baseauto_vali


#/////////////////////////////////////////////////////////////////////////////////////#
#___________________________________ Modelisation ____________________________________#
#/////////////////////////////////////////////////////////////////////////////////////#
## On va modeliser ici directement le cout des sinistres, sans decomposition frequence-cout moyen. Comparaison sommaire sur le cout moyen par sinistre sur les differentes bases de donnees:
summary(baseauto.attri)
summary(baseauto_appren)
summary(baseauto_vali)
(coutMoy_appren <- mean(baseauto_appren$Sinistralite.agregee))
(coutMoy_vali <- mean(baseauto_vali$Sinistralite.agregee))


#____________________Modele GLM log-Poisson_____________________#
baseauto_appren <- NULL
baseauto_appren <- baseauto_appren.origine		# pour recuperer les valeurs nulles de la sinistralite
glm_logPoisson_complet <- glm(Sinistralite.agregee ~ Puissance + AgeVoiture + AgeConducteur + Marque + Gaz + Région + Densité, family = poisson(link="log"), data = baseauto_appren)
summary(glm_logPoisson_complet)					# les variables et leurs modalites ont toutes l'air significatives
anova(glm_logPoisson_complet, test = "Chisq")	# l'ensemble des covariables a l'etude semble etre pertinent
## Logiquement, la selection de modele qui suit ne devrait pas modifier le modele courant vu les resultats du summary sur le modele...:
library(MASS)
glm_logPoisson_optimized <- stepAIC(glm_logPoisson_complet, direction = "backward")
attributes(glm_logPoisson_optimized)

#### Residus ####
## A ce stade, on peut croire que le modele est tres bon. Un oeil aux residus du modele permet de completer cette vision. Le premier graphique expose les valeurs prevues en log (d'ou les negatifs).
median(baseauto_appren$Sinistralite.agregee - glm_logPoisson_optimized$fitted.values)
mean(baseauto_appren$Sinistralite.agregee - glm_logPoisson_optimized$fitted.values)
quartz(height = 6, width = 10.5) ; plot(glm_logPoisson_optimized, which = 1:4)		
## Conclusion: 
##   * pas de tendance hyper claire a sur-estimer ou sous-estimer lorsque exp(predicted) augmente sur le 1er graphique
##   * des residus qui ont tendance a ne plus du tout avoir de forme gaussienne a partir d'un certain quantile sur le 2eme graphique
##   * residus studentises (3e graph) et distance de Cook (4e) nous donnent les observations aberrantes (nous pourrions les enlever de la base d'apprentissage pour stabiliser la modelisation).
##   * la distance de Cook (4e) montre l'influence d'une observ. sur l'utilisation des Moindres Carres. Mesure l'effet de la suppression (levier) d'1 donnee sur l'estimation, son importance sur l'estimation.


#____________________Melange log-Poisson zero-inflate_____________________#
require(gamlss)
require(pscl)
## On ne modelise pas a l'aide de covariable ici le parametre d'inflation en zero: pi_0 est donc une constante dans ce cas!
glm_zip_complet <- zeroinfl(Sinistralite.agregee ~ Puissance + AgeVoiture + AgeConducteur + Marque + Gaz + Région + Densité | 1, data = baseauto_appren, dist = "poisson", link = "logit")
summary(glm_zip_complet)

quantile(baseauto_appren$Sinistralite.agregee, seq(from=0.95, to=0.97, by=0.001))
pi0 <- as.numeric(exp(glm_zip_complet$coefficients$zero[1]) / (1 + exp(glm_zip_complet$coefficients$zero[1])))		# prop. affectee au Dirac(0), auquel il faut + la prop. moy. de 0 generes par Poisson.
as.numeric(exp(glm_zip_complet$coefficients$count[1]))																# cout moyen de la loi de Poisson de l'individu de reference
proba0.Poisson <- as.numeric(exp(-exp(glm_zip_complet$coefficients$count[1])))										# probabilite en 0 pour la loi de Poisson pour l'individu de reference: exp(-lambda)
## Proportion de 0 generes par le modele:
as.numeric(pi0 + (1-pi0) * proba0.Poisson)																			# prop. de 0 par le modele coherente avec la realite (cf quantiles de la sinistralite).



#/////////////////////////////////////////////////////#
#-------------------- PREVISIONS ---------------------#
#/////////////////////////////////////////////////////#
## Attention la fonction predict ne prend pas en compte les offsets! il faut les integrer a la main (https://stackoverflow.com/questions/24133234/r-glm-object-and-prediction-using-offsets)
head(baseauto_vali)
summary(baseauto_vali)

#____________________Modele GLM log-Poisson_____________________#
summary(glm_logPoisson_optimized)
logPoisson.predict_valid <- predict(glm_logPoisson_optimized, newdata = baseauto_vali, type = "response")
summary(logPoisson.predict_valid)																# reponse en log.
summary(baseauto_vali$Sinistralite.agregee)														# modele sousestime la sinistralite moyenne, mais tres mauvais sur les extremes

#____________________Melange log-Poisson zero-inflate_____________________#
summary(glm_zip_complet)
zip.predict_valid <- predict(glm_zip_complet, newdata = baseauto_vali, type = "response")
zip.predict_valid_probaZero <- predict(glm_zip_complet, newdata = baseauto_vali, type = "zero")
nb.zero.predits <- sum(zip.predict_valid_probaZero)
sum(baseauto_vali$Sinistralite.agregee == 0)

summary(zip.predict_valid)																		# reponse en log.
summary(baseauto_vali$Sinistralite.agregee)														# modele surestime de peu la sinistralite moyenne, encore tres mauvais sur les extremes


#********************************************************************************#
#---------------------- COMPARAISON DES MODELES DE CHARGE -----------------------#
#********************************************************************************#
modeles.coutMoyen <- list("Log-Poisson" = glm_logPoisson_optimized, "ZI-Poisson" = glm_zip_complet)
(comparaison <- rbind(Vraisemb = sapply(modeles.coutMoyen, function(x) round(logLik(x),0)), Deg.lib=sapply(modeles.coutMoyen, function(x) df.residual(x)), AIC=sapply(modeles.coutMoyen, function(x) AIC(x))) )
## => le modele ZIP semble plus adapte: il a une bien meilleure vraisemblance avec peu de difference en termes de degres de liberte.


s